<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reservation extends Model 
{

    protected $table = 'reservations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('number_of_guests', 'check_in_date', 'check_out_date', 'check_in_hours', 'check_out_hours');

    public function bookings()
    {
        return $this->hasMany('App\Models\Booking');
    }

    public function invoices()
    {
        return $this->hasMany('App\Models\Invoices');
    }

}